# 画面設計書 44-kubectl kuberc

## 概要

本ドキュメントは、kubectlのkubercコマンドの画面設計書である。kuberc設定ファイルを管理し、kubectlのデフォルト設定やコマンドエイリアスをカスタマイズするためのCLIコマンドの仕様を定義する。feature gate有効時のみ利用可能。

### 本画面の処理概要

**業務上の目的・背景**：kubectlを日常的に使用する運用者は、頻繁に使用するフラグやコマンドの組み合わせを繰り返し入力する必要がある。kubercコマンドはkuberc設定ファイル（Preferenceリソース）を管理することで、コマンドごとのデフォルトフラグ値やエイリアスを設定し、運用効率を向上させる。

**画面へのアクセス方法**：ターミナルから `kubectl kuberc SUBCOMMAND` を実行する。feature gateが有効でない場合はコマンド自体が利用不可。

**主要な操作・処理内容**：
1. `kubectl kuberc view` - 現在のkuberc設定を表示する（YAML/JSON形式）
2. `kubectl kuberc set` - kuberc設定にデフォルト値やエイリアスを追加・更新する
3. viewサブコマンドはkubercファイルが存在しない場合、デフォルト設定の生成を提案する
4. setサブコマンドは `--section defaults` でデフォルト設定、`--section aliases` でエイリアス設定を管理する

**画面遷移**：CLIコマンドであるため画面遷移は存在しない。kubectlルートコマンドの「Other Commands」カテゴリに属する。

**権限による表示制御**：ローカルファイルの読み書きのみ行うため、Kubernetes APIへのアクセス権限は不要。ファイルシステムの読み書き権限が必要。KUBERC=off環境変数でkuberc機能自体を無効化できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 112 | kuberc設定 | 主機能 | kubercファイルによるkubectlのエイリアスとデフォルト設定を管理する主処理 |

## 画面種別

設定管理（CLIサブコマンド構造）

## URL/ルーティング

```
kubectl kuberc SUBCOMMAND [flags]
```

サブコマンド：
- `kubectl kuberc view [--output yaml|json] [--kuberc PATH]`
- `kubectl kuberc set --section (defaults|aliases) --command COMMAND [flags]`

## 入出力項目

### 入力項目（viewサブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --output | string | 任意 | yaml | 出力形式（yaml/json） |
| --kuberc | string | 任意 | デフォルトパス | kubercファイルのパス |

### 入力項目（setサブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --section | string | 必須 | - | 設定セクション（defaults/aliases） |
| --command | string | 必須 | - | 設定対象コマンド名（例: get, create） |
| --name | string | aliases時必須 | - | エイリアス名 |
| --option | []string | 任意 | [] | flag=value形式のオプション設定（複数指定可） |
| --prependarg | []string | 任意 | [] | コマンドに前方追加する引数（aliases時のみ） |
| --appendarg | []string | 任意 | [] | コマンドに後方追加する引数（aliases時のみ） |
| --overwrite | bool | 任意 | false | 既存エントリの上書きを許可 |
| --kuberc | string | 任意 | デフォルトパス | kubercファイルのパス |

### 出力項目（view）

kubercファイルの内容がYAMLまたはJSON形式で出力される。

## 表示項目

view出力例：
```yaml
apiVersion: kubectl.config.k8s.io/v1beta1
kind: Preference
defaults:
- command: get
  options:
  - name: output
    default: wide
aliases:
- name: getn
  command: get
  prependArgs:
  - nodes
  options:
  - name: output
    default: wide
```

## イベント仕様

### 1-view実行

1. `Complete` でkubercファイルのパスを解決（--kubercフラグまたはデフォルト）
2. `Validate` でKUBERC=offでないことを確認
3. `Run` でファイルを読み込み、YAML解析してプリンターで出力
4. ファイルが存在しない場合、明示的指定ならエラー、暗黙的ならデフォルト生成を提案

### 2-set実行

1. `Complete` でkubercファイルのパスを解決
2. `Validate` で以下を検証：
   - sectionがdefaultsまたはaliasesであること
   - aliases時にnameが必須であること
   - defaults時にname/prependarg/appendargが指定されていないこと
3. `Run` で既存ファイルを読み込み（なければ新規作成）、設定を追加/更新してファイルに保存

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| view | ローカルファイル | READ | kubercファイルの読み取り |
| set | ローカルファイル | WRITE | kubercファイルの作成/更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| ERR-01 | エラー | `KUBERC is disabled via KUBERC=off environment variable` | KUBERC=off設定時 |
| ERR-02 | エラー | `kuberc file not found at %s` | 明示指定パスにファイルがない場合 |
| ERR-03 | エラー | `--section must be "defaults" or "aliases"` | 不正なsection値 |
| ERR-04 | エラー | `--name is required when --section=aliases` | aliases時にname未指定 |
| ERR-05 | エラー | `defaults for command %q already exist, use --overwrite to replace` | 上書き非許可時の重複 |
| ERR-06 | エラー | `alias %q already exists, use --overwrite to replace` | 上書き非許可時のエイリアス重複 |
| ERR-07 | エラー | `invalid option format %q, expected flag=value` | option形式不正 |
| INFO-01 | 情報 | `kuberc file not found at %s` | 暗黙パスにファイルがない場合（提案を表示） |

## 例外処理

- kubercファイルの読み取り/書き込み権限がない場合、ファイルシステムエラーが返される
- YAMLパースエラーの場合、`error parsing kuberc file` メッセージが返される
- KUBERC=off環境変数設定時は機能全体が無効化される

## 備考

- feature gate有効時のみ利用可能なコマンドである
- kubercファイルの形式はPreference（v1beta1）APIオブジェクト
- `--option` フラグの値からリーディングダッシュ（`--`）は自動的に除去される（set.go行227）
- view時にファイルが存在しない場合、対話的にデフォルト設定の生成を提案する機能がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | kuberc.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/kuberc.go` | NewCmdKubeRC（行45-59）でサブコマンド（view, set）が追加される構造を理解する |
| 1-2 | set.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/set.go` | SetOptions構造体（行71-84）のフィールドを理解する。Section, Command, AliasName, Options, PrependArgs, AppendArgs |
| 1-3 | view.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/view.go` | ViewOptions構造体（行51-59）のフィールドを理解する |

**読解のコツ**: v1beta1.Preference型がkuberc設定ファイルのデータモデルである。AliasOverrideとCommandDefaultsの構造を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kuberc.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/kuberc.go` | NewCmdKubeRC関数（行45-59）がルートコマンドを構築し、view/setをAddCommandで追加 |

#### Step 3: viewサブコマンドの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | view.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/view.go` | Run()メソッド（行114-155）でファイル読み込み→YAML解析→プリンター出力の流れ。ファイル未存在時のデフォルト生成提案ロジック（行120-135）に注目 |

#### Step 4: setサブコマンドの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | set.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/set.go` | Run()メソッド（行168-190）でファイル読み込み→設定更新→保存。setDefaults（行239-263）とsetAlias（行266-314）の分岐処理に注目 |

### プログラム呼び出し階層図

```
NewCmdKubeRC (kuberc.go:45)
    |
    +-- NewCmdKubeRCView (view.go:62)
    |       +-- Complete → Validate → Run
    |               +-- os.ReadFile()
    |               +-- yaml.Unmarshal()
    |               +-- printer.PrintObj()
    |
    +-- NewCmdKubeRCSet (set.go:97)
            +-- Complete → Validate → Run
                    +-- loadOrCreatePreference()
                    +-- parseOptions()
                    +-- setDefaults() / setAlias()
                    +-- kuberc.SavePreference()
```

### データフロー図

```
[入力]               [処理]                    [出力]

kubercファイル ──> view: yaml.Unmarshal ──> stdout (YAML/JSON)
                  set: loadOrCreate
                      → setDefaults/setAlias
                      → SavePreference    ──> kubercファイル(更新)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kuberc.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/kuberc.go` | ソース | kubercルートコマンドの定義 |
| view.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/view.go` | ソース | viewサブコマンドの実装 |
| set.go | `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/set.go` | ソース | setサブコマンドの実装 |
| v1beta1/ | `staging/src/k8s.io/kubectl/pkg/config/v1beta1/` | ソース | Preference型定義（kubercファイル形式） |
| kuberc/ | `staging/src/k8s.io/kubectl/pkg/kuberc/` | ソース | kuberc設定ファイルのロード・保存ユーティリティ |
